/**
  Copyright (c) 2012 Freescale Semiconductor
  
  \file       GO_Utils.c
  \brief      function wrappers for some common operations
  \author     Freescale Semiconductor
  \author     Automotive Systems Solutions Engineering
  \author     DB, r54930
  \version    1.0
  \date       27/Feb/2014
  
  * History:  27/Feb/2014- Initial Version

* Copyright (c) 2014, Freescale, Inc.  All rights reserved.
*
*
* No part of this document must be reproduced in any form - including copied,
* transcribed, printed or by any electronic means - without specific written
* permission from Freescale Semiconductor.
*
   
*/

#include "common.h"
#include "Graphics.h"
#include "DMAHandler.h"

#include "mc_parameters.h"
#include "FSLtime.h"


uint8_t CopyGO2GO(Graphics_Object_t* sourceGO, Graphics_Object_t* targetGO, uint16_t x, uint16_t y){
uint8_t dmachnl;
        dmachnl = DMAHR_GetNextFreeChannel();
        if (dmachnl == DMAHR_NOCHNL) return DMAHR_NOCHNL;
        else Graphics_Paste(dmachnl, sourceGO, targetGO, x, y, NULL_PTR);
}       

uint8_t GOclear(const Graphics_Object_t* theGO, uint32_t clearColor){
uint8_t dmachnl;

        dmachnl = DMAHR_GetNextFreeChannel();
        if (dmachnl == DMAHR_NOCHNL) return DMAHR_NOCHNL;
        else  Graphics_BlankArea(dmachnl, theGO, clearColor, NULL_PTR);  
}